// -------------------------------------------------------------------------------------------------------------------------------------

// Dear API client,

// We kindly remind you that this sample data is provided to you for information and trial purpose only.                

// You shall make use according to our General Conditions applicable to EPEX SPOT Information Product that you expressly accepted.     

// Therefore, you are not entitled to access and use it for External Usage, including commercial purposes.                

// Moreover, in no case should EPEX SPOT be held liable for the content of this data.                           

// Kind regards,

// Your EPEX SPOT Market Data Team

// -------------------------------------------------------------------------------------------------------------------------------------

package com.jeejava.soap.api;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Scanner;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 * 
 * @version 1.1
 * @author EPEX SPOT SE
 *
 */
public class SampleAPICode {
	
	//Store the ETS API URL. Please double check the URL before executing the script so that it corresponds to your test environment.
	private static String apiurl = https:// api1-ets.svpx.simu2.epexspot.com/OpenAccess /3.6";
	
	//Store the ETS API User Name. Please update the user name before executing the script.
	private static String uname = "API";
	
	//Store the ETS API Password. Please update the password before executing the script.
	private static String pwd = "xxxxxx";
	
	//Timeout of 5 secs is defined
	private static final int TIME_OUT = 5000;
	
	//Store the user's local machine path. This is pointing to the user's local desktop who is currently running this sample code
	private static final String path = System.getProperty("user.home") + "/Desktop/";
	
	//Please ensure that the *.jks file is stored in the user's local desktop before executing the script for testing purpose
	private static final String CLIENT_KEYSTORE_PATH = path + "/ETSAPI.jks";
	
	//Please update the keystore password before executing the script for testing purpose
	private static final String CLIENT_KEYSTORE_PASSWORD = "xxxxx";

public static void main(String[] args) throws IOException, ParserConfigurationException, SAXException {
	
	/*
	 * Call the function to authenticate the connection with the client certificate
	 */
	try {
		certificateAuthentication(apiurl);
	} catch (KeyManagementException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	} catch (UnrecoverableKeyException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	} catch (NoSuchAlgorithmException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	} catch (CertificateException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	} catch (KeyStoreException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	} catch (SOAPException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	}
	
	
	/*Call the function to build the xml request for the API method EstablishConnection.
	 *The function returns the request xml for the API method EstablishConnection.
	 */
	String requestXml = buildLoginRequestXml(uname, pwd);
	
	
	/*Call the function to send the EstablishConnection request xml to the ETS API URL via SOAP Connection
	 *and retrieve the response from the ETS API
	 */
	String result = postRequest(apiurl, requestXml, "EstablishConnection");
	
	//Call the function to save the response retrieved from ETS API in the Desktop of local user's machine
	boolean flag = exportApiResponse(result, "EstablishConnection_Response.xml", path);
	
	if (flag == true) {
		System.out.println("Successfully saved EstablishConnection_Response.xml in: "+path);
	}
	
	//Call the function to retrieve the Session key from the API response  of the method EstablishConnection
	String sessionKey = getSessionKey(result);
	
	/*Call the function to build the xml request for the API method Logout.
	 *The function returns the request xml for the API method Logout.
	 */
	requestXml = buildLogoutRequestXml(uname, sessionKey);
	
	/*Call the function to send the Logout request xml to the ETS API URL via SOAP Connection
	 *and retrieve the response from the ETS API
	 */
	result = postRequest(apiurl, requestXml, "Logout");
	
	
	flag = exportApiResponse(result, "Logout_Response.xml", path);
	
	if (flag == true) {
		System.out.println("Successfully saved Logout_Response.xml in: "+path);
	}
}

private static void certificateAuthentication (String apiurl) throws KeyManagementException,
UnrecoverableKeyException, NoSuchAlgorithmException,
CertificateException, KeyStoreException, IOException, SOAPException {
	/*
	 * Load the keystore
	 */
	char[] password = CLIENT_KEYSTORE_PASSWORD.toCharArray();
	KeyStore keystore = loadKeystore(CLIENT_KEYSTORE_PATH, password);

	/*
	 * Create a trust manager that validates the certificate
	 */
	TrustManager[] trustManager = new TrustManager[] { new X509TrustManager() {
		public java.security.cert.X509Certificate[] getAcceptedIssuers() {
			return null;
		}

		public void checkClientTrusted(X509Certificate[] certs,
				String authType) {
		}

		public void checkServerTrusted(X509Certificate[] certs,
				String authType) throws CertificateException {

		}
	} };

	KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory
			.getDefaultAlgorithm());

	kmf.init(keystore, password);

	// set the trust manager
	SSLContext sc = SSLContext.getInstance("SSL");

	sc.init(kmf.getKeyManagers(), trustManager,
			new java.security.SecureRandom());

	HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());

	// create an all-trusting host name verifier
	HostnameVerifier allHostsValid = new HostnameVerifier() {
		public boolean verify(String hostname, SSLSession session) {
			return true;
		}
	
	};
	HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);

}

private static KeyStore loadKeystore(String filePath, char[] password)
		throws NoSuchAlgorithmException, CertificateException, IOException,
		KeyStoreException {

	FileInputStream is = new FileInputStream(new File(filePath));

	final KeyStore keystore = KeyStore.getInstance(KeyStore
			.getDefaultType());

	keystore.load(is, password);

	return keystore;
}
	

private static String buildLogoutRequestXml(String uname, String sessionKey) {
	
	/*Building the API XML Request for the method Logout with the parameters uname (i.e. API user name)
	 * and session key of the API user which were retrieved from the response of API method EstablishConnection
	 */
	String logOut = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:urn=\"urn:openaccess\">"+
			   "<soapenv:Header>"+
			      "<urn:SessionToken>"+
			         "<urn:userLoginName>"+uname+"</urn:userLoginName>"+
			         "<urn:sessionKey>"+sessionKey+"</urn:sessionKey>"+
			      "</urn:SessionToken>"+
			      "<urn:AsynchronousResponseHeader>"+
			         "<urn:asynchronousResponse>1</urn:asynchronousResponse>"+
			         "<urn:responseToken>1</urn:responseToken>"+
			      "</urn:AsynchronousResponseHeader>"+
			   "</soapenv:Header>"+
			   "<soapenv:Body>"+
			      "<urn:Logout/>"+
			   "</soapenv:Body>"+
			"</soapenv:Envelope>";
			return logOut;
}

private static String getSessionKey(String response) throws ParserConfigurationException, SAXException, IOException {
	
	/*Getting the Session Key from the Establish Connection Response and returns the session key to the main
	 *class
	 */
	DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
	InputSource src = new InputSource();
	src.setCharacterStream(new StringReader(response));

	Document doc = builder.parse(src);
	
    String userSessionKey = doc.getElementsByTagName("ns:sessionKey").item(0).getTextContent();
	return userSessionKey;
}

private static boolean exportApiResponse(String result, String fileName, String path) {
	
	/*Exporting the response retrieved from in an XML format file in the desktop of local
	 * user's machine
	 */
	DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
	 
    DocumentBuilder builder;
    try
    {
        builder = factory.newDocumentBuilder();
        Document document = builder.parse( new InputSource(new StringReader( result ) ) );
        TransformerFactory tranFactory = TransformerFactory.newInstance();
        Transformer aTransformer = tranFactory.newTransformer();
        Source src = new DOMSource( document );
        Result dest = new StreamResult( new File(path+fileName));
        aTransformer.transform( src, dest );

    } catch (Exception e)
    {
        e.printStackTrace();
    }
    
    return true;
	
}


private static String postRequest(String apiurl, String requestXml, String soapAction) throws IOException {
	
	/*Initiating the HTTPS URL Connection to the apiurl in order to send the API messages for several operations
	 *This function returns the API response retrieved from the open connection to the main class
	 */
	URL obj = new URL(apiurl);
    HttpsURLConnection con = (HttpsURLConnection) obj.openConnection();
    
    con.setConnectTimeout(TIME_OUT);
    
    
    //adding all the required headers in the request header
    con.setRequestMethod("POST");
    con.setRequestProperty("Content-Type", "text/xml;charset=UTF-8");
    con.setRequestProperty("SOAPAction", soapAction);
    
   //Triggering the POST method to send the request to the HTTPS URL connection
    con.setDoOutput(true);
    
    //Writing the request content over the HTTP connection
    DataOutputStream outputStream= new DataOutputStream(con.getOutputStream());
    outputStream.write(requestXml.getBytes());
    
    InputStream in = null;
    
    if (con.getResponseCode() >= 200 && con.getResponseCode()<= 300 ) {
        in = con.getInputStream();

    } else {
        in = con.getErrorStream();
        
    }
    @SuppressWarnings("resource")
	Scanner s = new Scanner(in).useDelimiter("\\A");
    String result = s.hasNext() ? s.next() : "";
	return result;
	
	
}

private static String buildLoginRequestXml(String uname, String pwd) {
	
	/*Building the API XML Request for the method EstablishConnection with the parameters uname (i.e. API user name)
	 * and pwd (i.e. Password of the API user)
	 */
	String establishConnection = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"+
			"<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:urn=\"urn:openaccess\">"+
			   "<soapenv:Header/>"+
			   "<soapenv:Body>"+
			      "<urn:EstablishConnection>"+
			         "<userLoginName>"+uname+"</userLoginName>"+
			         "<password>"+pwd+"</password>"+
			      "</urn:EstablishConnection>"+
			   "</soapenv:Body>"+
			"</soapenv:Envelope>";
	return establishConnection;
}
}